/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.pdu.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.IPAddress;
import com.cisco.pt.ipc.enums.PtmpTypeValue;
import com.cisco.pt.ipc.sim.pdu.OSPFHelloPacket;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFPacketImpl;
import com.cisco.pt.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSPFHelloPacketImpl
extends OSPFPacketImpl
implements OSPFHelloPacket {
    protected IPAddress networkMask;
    protected Short helloInterval;
    protected Byte option;
    protected Byte priority;
    protected int deadInterval;
    protected IPAddress designatedRouter;
    protected IPAddress backupDesignatedRouter;
    protected List<IPAddress> neighbors;

    public OSPFHelloPacketImpl() {
        this.fieldNames.add("OSPFHelloPacketImpl_networkMask");
        this.fieldNames.add("OSPFHelloPacketImpl_helloInterval");
        this.fieldNames.add("OSPFHelloPacketImpl_option");
        this.fieldNames.add("OSPFHelloPacketImpl_priority");
        this.fieldNames.add("OSPFHelloPacketImpl_deadInterval");
        this.fieldNames.add("OSPFHelloPacketImpl_designatedRouter");
        this.fieldNames.add("OSPFHelloPacketImpl_backupDesignatedRouter");
        this.fieldNames.add("OSPFHelloPacketImpl_neighbors");
        this.signalType = "OspfHelloPacket";
    }

    @Override
    public IPAddress getNetworkMask() {
        return this.networkMask;
    }

    @Override
    public void setNetworkMask(IPAddress networkMask) {
        this.networkMask = networkMask;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFHelloPacketImpl_networkMask")) continue;
            this.fieldTable.set(i, new Pair<String, IPAddress>("OSPFHelloPacketImpl_networkMask", networkMask));
            return;
        }
    }

    @Override
    public Short getHelloInterval() {
        return this.helloInterval;
    }

    @Override
    public void setHelloInterval(Short helloInterval) {
        this.helloInterval = helloInterval;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFHelloPacketImpl_helloInterval")) continue;
            this.fieldTable.set(i, new Pair<String, Short>("OSPFHelloPacketImpl_helloInterval", helloInterval));
            return;
        }
    }

    @Override
    public Byte getOption() {
        return this.option;
    }

    @Override
    public void setOption(Byte option) {
        this.option = option;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFHelloPacketImpl_option")) continue;
            this.fieldTable.set(i, new Pair<String, Byte>("OSPFHelloPacketImpl_option", option));
            return;
        }
    }

    @Override
    public Byte getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(Byte priority) {
        this.priority = priority;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFHelloPacketImpl_priority")) continue;
            this.fieldTable.set(i, new Pair<String, Byte>("OSPFHelloPacketImpl_priority", priority));
            return;
        }
    }

    @Override
    public int getDeadInterval() {
        return this.deadInterval;
    }

    @Override
    public void setDeadInterval(int deadInterval) {
        this.deadInterval = deadInterval;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFHelloPacketImpl_deadInterval")) continue;
            this.fieldTable.set(i, new Pair<String, Integer>("OSPFHelloPacketImpl_deadInterval", deadInterval));
            return;
        }
    }

    @Override
    public IPAddress getDesignatedRouter() {
        return this.designatedRouter;
    }

    @Override
    public void setDesignatedRouter(IPAddress designatedRouter) {
        this.designatedRouter = designatedRouter;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFHelloPacketImpl_designatedRouter")) continue;
            this.fieldTable.set(i, new Pair<String, IPAddress>("OSPFHelloPacketImpl_designatedRouter", designatedRouter));
            return;
        }
    }

    @Override
    public IPAddress getBackupDesignatedRouter() {
        return this.backupDesignatedRouter;
    }

    @Override
    public void setBackupDesignatedRouter(IPAddress backupDesignatedRouter) {
        this.backupDesignatedRouter = backupDesignatedRouter;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFHelloPacketImpl_backupDesignatedRouter")) continue;
            this.fieldTable.set(i, new Pair<String, IPAddress>("OSPFHelloPacketImpl_backupDesignatedRouter", backupDesignatedRouter));
            return;
        }
    }

    @Override
    public List<IPAddress> getNeighbors() {
        return this.neighbors;
    }

    @Override
    public void setNeighbors(List<IPAddress> neighbors) {
        this.neighbors = neighbors;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFHelloPacketImpl_neighbors")) continue;
            this.fieldTable.set(i, new Pair<String, List<IPAddress>>("OSPFHelloPacketImpl_neighbors", neighbors));
            return;
        }
    }

    @Override
    public PtmpTypeValue getFieldType(String fieldName) {
        if (fieldName.equals("OSPFHelloPacketImpl_networkMask")) {
            return PtmpTypeValue.IP_ADDRESS;
        }
        if (fieldName.equals("OSPFHelloPacketImpl_helloInterval")) {
            return PtmpTypeValue.SHORT;
        }
        if (fieldName.equals("OSPFHelloPacketImpl_option")) {
            return PtmpTypeValue.BYTE;
        }
        if (fieldName.equals("OSPFHelloPacketImpl_priority")) {
            return PtmpTypeValue.BYTE;
        }
        if (fieldName.equals("OSPFHelloPacketImpl_deadInterval")) {
            return PtmpTypeValue.INT;
        }
        if (fieldName.equals("OSPFHelloPacketImpl_designatedRouter")) {
            return PtmpTypeValue.IP_ADDRESS;
        }
        if (fieldName.equals("OSPFHelloPacketImpl_backupDesignatedRouter")) {
            return PtmpTypeValue.IP_ADDRESS;
        }
        if (fieldName.equals("OSPFHelloPacketImpl_neighbors")) {
            return PtmpTypeValue.DATA;
        }
        return super.getFieldType(fieldName);
    }

    private void populateFieldTable() {
        this.fieldTable.add(new Pair<String, IPAddress>("OSPFHelloPacketImpl_networkMask", this.networkMask));
        this.fieldTable.add(new Pair<String, Short>("OSPFHelloPacketImpl_helloInterval", this.helloInterval));
        this.fieldTable.add(new Pair<String, Byte>("OSPFHelloPacketImpl_option", this.option));
        this.fieldTable.add(new Pair<String, Byte>("OSPFHelloPacketImpl_priority", this.priority));
        this.fieldTable.add(new Pair<String, Integer>("OSPFHelloPacketImpl_deadInterval", this.deadInterval));
        this.fieldTable.add(new Pair<String, IPAddress>("OSPFHelloPacketImpl_designatedRouter", this.designatedRouter));
        this.fieldTable.add(new Pair<String, IPAddress>("OSPFHelloPacketImpl_backupDesignatedRouter", this.backupDesignatedRouter));
        this.fieldTable.add(new Pair<String, List<IPAddress>>("OSPFHelloPacketImpl_neighbors", this.neighbors));
    }

    @Override
    public void read(EncodedBuffer buffer) {
        super.read(buffer);
        this.networkMask = this.readIPAddress(buffer);
        this.helloInterval = this.readShort(buffer);
        this.option = this.readByte(buffer);
        this.priority = this.readByte(buffer);
        this.deadInterval = this.readInt(buffer);
        this.designatedRouter = this.readIPAddress(buffer);
        this.backupDesignatedRouter = this.readIPAddress(buffer);
        List<Object> tempList1 = this.readVector(buffer);
        this.neighbors = new ArrayList<IPAddress>();
        for (Object o : tempList1) {
            this.neighbors.add((IPAddress)o);
        }
        this.populateFieldTable();
    }

    @Override
    public void pduRead(EncodedBuffer buffer) {
        super.pduRead(buffer);
        this.networkMask = this.pduReadIPAddress(buffer);
        this.helloInterval = this.pduReadShort(buffer);
        this.option = this.pduReadByte(buffer);
        this.priority = this.pduReadByte(buffer);
        this.deadInterval = this.pduReadInt(buffer);
        this.designatedRouter = this.pduReadIPAddress(buffer);
        this.backupDesignatedRouter = this.pduReadIPAddress(buffer);
        List<Object> tempList1 = this.pduReadVector(buffer, (byte)10);
        this.neighbors = new ArrayList<IPAddress>();
        for (Object o : tempList1) {
            this.neighbors.add((IPAddress)o);
        }
        this.populateFieldTable();
    }

    @Override
    public List<String> getOrderedFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    @Override
    public void encodeTypeAndPayload(EncodedBuffer buffer) {
        super.encodeTypeAndPayload(buffer);
        buffer.putIPAddress(this.networkMask);
        buffer.putShort(this.helloInterval);
        buffer.putByte(this.option);
        buffer.putByte(this.priority);
        buffer.putInt(this.deadInterval);
        buffer.putIPAddress(this.designatedRouter);
        buffer.putIPAddress(this.backupDesignatedRouter);
        buffer.putInt(this.neighbors.size());
        for (IPAddress item : this.neighbors) {
            buffer.putIPAddress(item);
        }
    }
}

